///////////////////////////////////////////////////////////////////////////////
//
//   ROCKWELL SEMICONDUCTOR SYSTEMS - COMMERCIAL GPS BUSINESS
//
///////////////////////////////////////////////////////////////////////////////
//
//
//   TITLE.C - Title Module
// 
//
//   DESCRIPTION
//
//   Processing function for the title screen.
//
//
//
//   REVISION HISTORY
//
//
////////////////////////////////////////////////////////////////////////////////

#include <conio.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <graph.h>
#include <time.h>


unsigned char *Line[4] = {"ROCKWELL", "WELCOME TO", "LABMON 50", "GOODBYE"};
unsigned char *options = {"roman"};
struct _videoconfig vc;

void Wait( unsigned short WaitTime );
void PrintLine( unsigned short WhichLine, unsigned short Color );
;

void TitleScreen(unsigned short Mode)
{
    unsigned char list[20];
    unsigned short LoopCount=0;
    
    /* Read header info from .FON files in current directory. */
    _registerfonts( "*.FON" );

    /* Set highest available graphics mode and get configuration. */
    if( !_setvideomode( _MAXRESMODE ) )
        exit( 1 );
    _getvideoconfig( &vc );

    /* Build options string. */
    strcat( strcat( strcpy( list, "t'" ), options ), "'");
    strcat( list, "h100w60b" );

    if( _setfont( list ) >= 0 )
    {
      if(Mode==0){
        while( LoopCount++ < 1){ 

          _clearscreen( _GCLEARSCREEN );
          PrintLine(0,1);
          Wait(1);
        
          _clearscreen( _GCLEARSCREEN );
          PrintLine(1,3);
          Wait(1);
        
          _clearscreen( _GCLEARSCREEN );
          PrintLine(2,5);
          Wait(1);
        }
      } else {
        while( LoopCount++ < 1){ 

          _clearscreen( _GCLEARSCREEN );
          PrintLine(0,1);
          Wait(1);
        
          _clearscreen( _GCLEARSCREEN );
          PrintLine(3,4);
          Wait(1);
        }
      }
    }
    else
    {
        _outtext( "Error: Can't set font: " );
        _outtext( list );
    }

    _unregisterfonts();
    _setvideomode( _DEFAULTMODE );
}


void Wait( unsigned short WaitTime )
{
   double DiffTime=0.0;
   time_t timer1,timer0;

   time( &timer0 );
   DiffTime = 0.0;
   while (DiffTime <= WaitTime){
     time( &timer1 );
     DiffTime = difftime( timer1,timer0 );
   }  

} // end Wait()

void PrintLine( unsigned short WhichLine, unsigned short Color )
{
   short  x, y;
   struct _fontinfo fi;

   /* Use length of text and height of font to center text. */
   x = (vc.numxpixels / 2) - (_getgtextextent( Line[WhichLine] ) / 2);
   y = (vc.numypixels / 8) + (_getgtextextent( Line[WhichLine] ) / 8);
   if( _getfontinfo( &fi ) )
   {
       _outtext( "Error: Can't get font information" );
   }
   _moveto( x, y );
   if( vc.numcolors > 2 )
       _setcolor( Color );

   /* Display text. */
   _outgtext( Line[WhichLine] );

} // end PrintLine()
